/*------------------------------------------------------------------------------*
 * File Name: EasyFit.h		 													*
 * Creation: GJL 7/17/03														*
 * Purpose: OriginC header file containing implementation of EasyFit class.		*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007				*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#ifndef _EASY_FIT_H
#define _EASY_FIT_H

class EasyFit
{
	public:
		// Constructors
		EasyFit() {Curve crvTemp; Init(crvTemp);}
		EasyFit(Curve& crvOriginal) {Init(crvOriginal);}
		EasyFit(LPCSTR lpcszYData) {Curve crvTemp(lpcszYData); Init(crvTemp);}
		EasyFit(LPCSTR lpcszXData, LPCSTR lpcszYData) {Curve crvTemp(lpcszXData, lpcszYData); Init(crvTemp);}
		EasyFit(Dataset& dsX, Dataset& dsY) {Curve crvTemp(dsX, dsY); Init(crvTemp);}
		EasyFit(Worksheet& wks, int nColX, int nColY) {Curve crvTemp(wks, nColX, nColY); Init(crvTemp);}
		EasyFit(Worksheet& wks, int nColY) {Curve crvTemp(wks, nColY); Init(crvTemp);}
		EasyFit(DataPlot& dp) {Curve crvTemp(dp); Init(crvTemp);}
		EasyFit(curvebase& crv, int& nNumMissingInCopy, int& nSrcOffset, DWORD dwOptions = 0,
			int nLower = -1, int nUpper = -1);

		// Destructor
		~EasyFit()
		{
			// Included to demonstrate calling destructor...Reset and Detach not required for destruction
			Settings.Reset();
			m_trWhole.Reset();
			m_crvInput.Detach();
			m_crvOutput.Detach();
		}

		// Methods
		BOOL Attach(LPCSTR lpcszYData) {return m_crvInput.Attach(lpcszYData);}
		BOOL Attach(LPCSTR lpcszXData, LPCSTR lpcszYData) {return m_crvInput.Attach(lpcszXData, lpcszYData);}
		BOOL CreateOutputCurve(const matrix& mResultCurves);
		BOOL PlotCurves();
		BOOL OutputResults(LPCSTR lpcszTitle = NULL, int nOutput = WRITE_SCRIPT_WINDOW);

		// Public Data Member
		Tree Settings;

	protected:
		// Virtual Methods
		virtual BOOL Init(Curve& crv);
		virtual BOOL Fit() {return FALSE;}

		// Protected Data Members
		Tree m_trWhole;
		Curve m_crvInput;

	private:
		// Private Data Member
		Curve m_crvOutput;
};

// Constructor
EasyFit::EasyFit(curvebase& crv, int& nNumMissingInCopy, int& nSrcOffset, DWORD dwOptions,
	int nLower, int nUpper)
{
	Curve crvTemp(crv, nNumMissingInCopy, nSrcOffset, dwOptions, nLower, nUpper);
	Init(crvTemp);
}

// Virtual Method
// Initialize input curve
BOOL EasyFit::Init(Curve& crv)
{
	if( crv.IsValid() )
		m_crvInput.Attach(crv.GetName());

	return m_crvInput.IsValid();
}

// Non-virtual Methods
// Create output curve in hidden worksheet
BOOL EasyFit::CreateOutputCurve(const matrix& mResultCurves)
{
	WorksheetPage wp;
	Worksheet wks;
	Column colX, colY;
	Dataset dsX, dsY;

	wp.Create("Origin", CREATE_HIDDEN);
	if( wp.IsValid() )
	{
		wks = wp.Layers();
		if( wks.IsValid() )
		{
			while( wks.GetNumCols() < 2 )
				wks.AddCol();
			colX.Attach(wks, 0);
			colY.Attach(wks, 1);
			if( colX.IsValid() && colY.IsValid() )
			{
				dsX.Attach(colX);
				dsY.Attach(colY);
				if( dsX.IsValid() && dsY.IsValid() )
				{
					mResultCurves.GetColumn(dsX, 0);
					mResultCurves.GetColumn(dsY, 1);
					m_crvOutput.Attach(wks, 0, 1);
					return TRUE;
				}
			}
		}
	}

	return FALSE;
}

// Plot input data and output fit curves in new graph
BOOL EasyFit::PlotCurves()
{
	GraphPage gp;
	gp.Create("Origin");

	if( gp.IsValid() )
	{
		GraphLayer gl;
		gl = gp.Layers();
		if( gl.IsValid() )
		{
			add_curve_to_graph_layer(m_crvInput, gl, 0, false, IDM_PLOT_SCATTER);
			add_curve_to_graph_layer(m_crvOutput, gl, 1, true, IDM_PLOT_LINE);
			return TRUE;
		}
	}

	return FALSE;
}

// Output settings and result parameters
BOOL EasyFit::OutputResults(LPCSTR lpcszTitle, int nOutput)
{
	Tree trResults;
	trResults = m_trWhole;
	tree_dump(trResults, lpcszTitle, nOutput);
	return TRUE;
}

#endif // _EASY_FIT_H